/* FINAL DRAGON MAP INITIALIZER 4/25/05
JESSE HARRIS
INITIALIZATIONS FOR MAP SCREEN AND CALL METAMAP DECODER
ALSO INITIALIZES CHARACTER SPRITE AND NPC SPRITES
ALSO RESETS NUMBER OF STEPS UNTIL MONSTER
ALSO INITIALIZES TEXT DISPLAY
ALSO CONTAINS PLOT CODE FOR TERRAIN BASED GATING
*/

#include <mygba.h>
#include <hel.h>
#include "metamapdecode.h"
#include "stuff.hpp"
#include "mtwister.h"

#include "gfx/sprite/celessprite.raw.c"
#include "gfx/sprite/celessprite.pal.c"
#include "gfx/sprite/frionel.raw.c"
#include "gfx/sprite/frionel.pal.c"

#include "gfx/text/Charset.raw.c"

//short test8x8_map0[20][20]
//unsigned short test8x8_cmap[256]
//unsigned char test8x8_blockgfx[1216]
//unsigned short tilelookup[]
//const short test_map0[100]
u16 * test;
extern u8 sprites[127];
//extern u8 youx, youy;
extern TMapScrollInfo MapInfo[];
extern TCustomTextInfo g_TextInfo;
extern player watashi;
extern map maplist[];
extern short tempspritex[127];
extern short tempspritey[127];
extern u8 stepstobattle;

int myMapInit()
{
    //PLOT
    if(watashi.playerstate & PS_SWAMPBOOTS)
    {
        maplist[3].coltable[7] = 1;
    }
    if(watashi.playerstate & PS_HIKINGBOOTS)
    {
        maplist[3].coltable[5] = 1;
    }
    if(watashi.playerstate & PS_DESERTSHOES)
    {
        maplist[3].coltable[8] = 1;
    }
    //END PLOT

    //reset steps to battle
    stepstobattle = 6 + D2d6;
    //less scorpions
    if(watashi.map == 3)
    {
        stepstobattle = stepstobattle + D2d6 + 9;
    }
    //initializations
    ham_ResetBg();
    ham_ResetObj();
    ham_SetBgMode(0);
    //text stuff initialization
       hel_CustomTextInit(&g_TextInfo,                 // Pointer to custom_text_info
                       (void*)Charset_Tiles,        // Pointer to the tile source data
                       SIZEOF_16BIT(Charset_Tiles), // Size of the tiles to be copied into Tile RAM, in number of 16bit chunks
                       1,                           // Color mode of the tile set: 0 = 16colors/16 palettes 1 = 256 colors / 1 palette
                       0,                           // PaletteNumber, just specify 0 when using 256 colors
                       0,                           // The size of the map (0-3). This depends on the map_rot parameter!
                       0);                          // 0 = normal map, 1 = rotation map
    ham_InitBg(g_TextInfo.BgNo, BG_ACTIVE_OFF, BG_PRIO_0, BG_MOSAIC_OFF);
    //for text background black background
    ham_SetFxMode(BIT2,BIT3,FX_MODE_ALPHABLEND);
    ham_SetFxAlphaLevel(15,0);

    //visual stuff
    //METAMAP !!!  WOOHOO!!!!
    test = metaMapDecode(maplist[watashi.map].map, maplist[watashi.map].lookuptable, maplist[watashi.map].sizex, maplist[watashi.map].sizey);
    //other visual set up stuff
    ham_LoadBGPal(maplist[watashi.map].palette, 256);
    ham_bg[3].ti = ham_InitTileSet(maplist[watashi.map].tiles, maplist[watashi.map].tilesize, 1, 1);
    MapInfo[3] = hel_MapInit(3, (2 * maplist[watashi.map].sizex) + 30, (2 * maplist[watashi.map].sizey) + 20, 0, (void*)test);
    ham_InitBg(3,0,0,0);
    //hel had a flicker problem when calling the function for a large scroll value at once, these inline statements correct this issue
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    hel_MapScrollBy(&MapInfo[3], watashi.x, watashi.y);
    ham_SetBgVisible(3,1);
    // Initialize the sprite palettes
    ham_LoadObjPal16((void*)celessprite_Palette, 0);
    ham_LoadObjPal16((void*)frionel_Palette, 1);
    
    // Create the player sprite and store the object number
    sprites[0] = ham_CreateObj((void*)celessprite_Bitmap,OBJ_SIZE_16X32,OBJ_MODE_NORMAL,0,0,0,0,0,0,0,112,72);
    ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[3 * 16 * 32 / 2]);
    //dynamic load of NPC sprites
    for (int x = 0; x < maplist[watashi.map].numsprite; x++)
    {
        int tempx = (maplist[watashi.map].sprite[4 * x] - watashi.x) * 16 + 112; //42
        int tempy = (maplist[watashi.map].sprite[4 * x + 1] - watashi.y ) * 16 + 80;  //9
        if(tempy > 160)
            {
            tempy = 160;
            }
        if(tempy < 0)
            {
            tempy = 256 - 16;
            }
        if(tempx > 240)
            {
            tempx = 240;
            }
        if(tempx < 0)
            {
            tempx = 512 - 16;
            }
        tempspritex[x + 1] = tempx;
        tempspritey[x + 1] = tempy;
        sprites[x + 1] = ham_CreateObj((void*)frionel_Bitmap,OBJ_SIZE_16X16,OBJ_MODE_NORMAL,0,1,0,0,0,0,0,tempx,tempy);
    }
    return 1;
}



/* END OF FILE */
